/*
 * Decompiled with CFR 0.152.
 */
package ptqi;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import cz.insophy.inplan.mrp.SupplyRequest;
import cz.insophy.inplan.plan.ActionActivity;
import cz.insophy.inplan.plan.Bubble;
import cz.insophy.inplan.plan.CumulativeWorkplaceActivity;
import cz.insophy.inplan.plan.OfflineActivity;
import cz.insophy.inplan.plan.RebuildActivity;
import cz.insophy.inplan.plan.WorkplaceActivity;
import cz.insophy.inplan.plan.WorkplaceActivityVisitor;
import cz.insophy.inplan.plan.WorkplaceSchedule;
import cz.insophy.inplan.property.PropertyDefinition;
import cz.insophy.inplan.sdgraph.MaterialSource;
import cz.insophy.inplan.sdgraph.SdgCrNode;
import cz.insophy.inplan.sdgraph.StoreDependencyGraph;
import cz.insophy.inplan.shop.CapabilityIsland;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.shop.MaterialQuantity;
import cz.insophy.inplan.shop.ShopConfiguration;
import cz.insophy.inplan.shop.Workplace;
import cz.insophy.inplan.store.StoreActivity;
import cz.insophy.inplan.store.StoreType;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.GeneralizedRequest;
import cz.insophy.inplan.superplan.ProductionTreeAlgorithms;
import cz.insophy.inplan.superplan.Superplan;
import cz.insophy.inplan.tab.TabularWriter;
import cz.insophy.inplan.util.CalendarHelper;
import cz.insophy.inplan.util.Localizer;
import cz.insophy.inplan.util.TimeSpan;
import cz.insophy.inplan.util.errlog.ErrorLog;
import cz.insophy.inplan.util.errlog.ErrorLogItem;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.TreeSet;
import ptqi.out_model.CustomerRequest;
import ptqi.out_model.ManufOrder;
import ptqi.out_model.ProblemCat;
import ptqi.out_model.Problems;
import ptqi.out_model.ProductionTree;
import ptqi.out_model.SupplyRequest;
import ptqi.out_model.WorkplaceActivities;

public class DataOutExporter {
    private final Superplan superplan;
    private final TabularWriter tabularWriter;
    private final ErrorLog errorLog;
    private final PropertyDefinition crMidPd;
    private final PropertyDefinition gorMidPd;
    private final PropertyDefinition origProdPd;
    private final PropertyDefinition garMidPd;

    public DataOutExporter(TabularWriter tabularWriter, Superplan superplan, ErrorLog errorLog) {
        this.superplan = superplan;
        this.tabularWriter = tabularWriter;
        this.errorLog = errorLog;
        this.crMidPd = superplan.getShopConf().getPropertyDefinition(cz.insophy.inplan.mrp.CustomerRequest.class, "m_id");
        Preconditions.checkNotNull(this.crMidPd, "CRs must have an m_id property");
        this.gorMidPd = superplan.getShopConf().getPropertyDefinition(GeneralizedOrderRequest.class, "m_id");
        Preconditions.checkNotNull(this.gorMidPd, "GORs must have a m_id property");
        this.origProdPd = superplan.getShopConf().getPropertyDefinition(GeneralizedOrderRequest.class, "origProd");
        Preconditions.checkNotNull(this.origProdPd, "GORs must have an origProd property");
        this.garMidPd = superplan.getShopConf().getPropertyDefinition(GeneralizedActionRequest.class, "m_id");
        Preconditions.checkNotNull(this.garMidPd, "GARs must have a m_id property");
    }

    private String getProduct(GeneralizedOrderRequest gor) {
        String product = (String)gor.getProperty(this.origProdPd);
        if (product == null) {
            product = gor.getProduct().getName();
        }
        return product;
    }

    public void exportGors() {
        try (TabularWriter.RowsWriter<ManufOrder> w = this.tabularWriter.writeTo(ManufOrder.class);){
            for (GeneralizedOrderRequest gor : this.superplan.getGors()) {
                long startDate = gor.getStartDate();
                long endDate = gor.getEndDate();
                int i = 0;
                for (GeneralizedActionRequest gar : gor.getGars()) {
                    if (gar.getInPlanQty() <= 1.0E-7) continue;
                    GarTimes t = new GarTimes(gar);
                    if (i == 0) {
                        startDate = t.bruttoStart;
                    }
                    endDate = t.endDate;
                    ++i;
                }
                ManufOrder mo = new ManufOrder();
                mo.orderName = gor.getId();
                mo.productName = this.getProduct(gor);
                mo.alternative = gor.getSelectedActiongram().getName();
                mo.qty = gor.getRequestedQty();
                mo.releaseDate = gor.getReleaseDate();
                mo.dueDate = gor.getDueDate();
                mo.start = startDate;
                mo.end = endDate;
                mo.state = gor.getState().name();
                mo.priority = gor.getPriority();
                mo.mId = (String)gor.getProperty(this.gorMidPd);
                w.writeRow(mo);
            }
        }
    }

    public void exportGars() {
        try (TabularWriter.RowsWriter<ProductionTree> w = this.tabularWriter.writeTo(ProductionTree.class);){
            for (GeneralizedOrderRequest gor : this.superplan.getGors()) {
                for (GeneralizedActionRequest gar : gor.getGars()) {
                    String capReq;
                    if (gar.getInPlanQty() <= 0.0 || (capReq = gar.getAction().getCapabilityReq()).equals("_art")) continue;
                    GarTimes t = new GarTimes(gar);
                    if (capReq.equals("_cooperation")) {
                        capReq = "";
                        if (!GeneralizedRequest.isDateValid(t.endDate)) {
                            this.errorLog.add(1, "data_out_export.bad_cooperation", "mo", gor.getId(), "op", gar.getAction().getName());
                            continue;
                        }
                    }
                    ProductionTree pt = new ProductionTree();
                    pt.orderName = gor.getId();
                    pt.productName = this.getProduct(gor);
                    pt.alternative = gor.getSelectedActiongram().getName();
                    pt.actionName = gar.getAction().getName();
                    pt.qty = gar.getInPlanQty();
                    pt.workcenter = capReq;
                    pt.startBrutto = t.bruttoStart;
                    pt.startNetto = t.startDate;
                    pt.end = t.endDate;
                    pt.lps = gar.getLatestPossibleStart();
                    pt.lpe = gar.getDueDate();
                    pt.mId = (String)gar.getProperty(this.garMidPd);
                    w.writeRow(pt);
                }
            }
        }
    }

    public void exportWorkplaceActivities() {
        try (TabularWriter.RowsWriter<WorkplaceActivities> w = this.tabularWriter.writeTo(WorkplaceActivities.class);){
            ShopConfiguration conf = this.superplan.getShopConf();
            for (Workplace wp : conf.getWorkplaces()) {
                if (wp.hasCapability("_cooperation") || wp.hasCapability("_art")) continue;
                CapabilityIsland island = conf.getIsland(wp);
                WorkplaceSchedule schedule = this.superplan.getPlan().getWorkplaceSchedule(wp);
                WaRowWriterVisitor visitor = new WaRowWriterVisitor(w, island, wp, this.garMidPd);
                schedule.visitActivities(Long.MIN_VALUE, Long.MAX_VALUE, visitor);
                visitor.visit(visitor.rebuild);
            }
        }
    }

    public void exportSrs() {
        try (TabularWriter.RowsWriter<SupplyRequest> w = this.tabularWriter.writeTo(SupplyRequest.class);){
            for (cz.insophy.inplan.mrp.SupplyRequest sr : this.superplan.getSupplyRequests()) {
                if (sr.getState() != SupplyRequest.State.PROPOSED) continue;
                SupplyRequest s2 = new SupplyRequest();
                s2.orderName = sr.getId();
                s2.materialName = sr.getMaterial().getName();
                s2.dueDate = sr.getTime();
                s2.qty = sr.getQty();
                s2.state = sr.getState().name();
                w.writeRow(s2);
            }
        }
    }

    public void exportCrs() {
        Calendar cal = Calendar.getInstance();
        StoreDependencyGraph graph = this.superplan.getSDGraph();
        try (TabularWriter.RowsWriter<CustomerRequest> w = this.tabularWriter.writeTo(CustomerRequest.class);){
            for (cz.insophy.inplan.mrp.CustomerRequest cr : this.superplan.getCustomerRequests()) {
                SdgCrNode node = graph.getNode(cr);
                Long availDate = null;
                if (node.isComplete()) {
                    if (node.getMaterialSource() == MaterialSource.STORE) {
                        cal.setTimeInMillis(this.superplan.getFixationDate());
                        CalendarHelper.setDayStart(cal);
                        availDate = cal.getTimeInMillis();
                    } else {
                        availDate = node.getMatprodPreparedTime();
                    }
                }
                CustomerRequest c = new CustomerRequest();
                c.crName = cr.getId();
                c.matprod = cr.getMaterial().getName();
                c.qty = cr.getQty();
                c.dueDate = cr.getTime();
                c.priority = cr.getPriority();
                c.mId = (String)cr.getProperty(this.crMidPd);
                c.availabilityDate = availDate;
                w.writeRow(c);
            }
        }
    }

    public void exportErrorLog() {
        EnumMap<ErrorLogItem.Level, String> errorNames = new EnumMap<ErrorLogItem.Level, String>(ErrorLogItem.Level.class);
        errorNames.put(ErrorLogItem.Level.ERROR, "error");
        errorNames.put(ErrorLogItem.Level.WARNING, "warning");
        TreeSet<String> encounteredProblems = Sets.newTreeSet();
        try (TabularWriter.RowsWriter<Problems> w = this.tabularWriter.writeTo(Problems.class);){
            for (ErrorLogItem error : this.errorLog) {
                String key = error.getMessageKey();
                Problems p = new Problems();
                p.problem = key;
                p.level = (String)errorNames.get((Object)error.getLevel());
                p.priority = error.getPriority();
                p.details = error.getMessage();
                w.writeRow(p);
                encounteredProblems.add(key);
            }
        }
        String suffix = ".desc";
        try (TabularWriter.RowsWriter<ProblemCat> w = this.tabularWriter.writeTo(ProblemCat.class);){
            ArrayList<String> keys = Lists.newArrayList(ResourceBundle.getBundle("ptqi.Messages", Localizer.getCurrentLocale()).keySet());
            Collections.sort(keys);
            for (String key : keys) {
                if (!key.endsWith(suffix)) continue;
                String problem = key.substring(0, key.length() - suffix.length());
                String desc = Localizer.getString(key);
                ProblemCat pc = new ProblemCat();
                pc.problem = problem;
                pc.description = desc;
                w.writeRow(pc);
                encounteredProblems.remove(problem);
            }
            for (String problem : encounteredProblems) {
                String desc = Localizer.getStringIfExists(problem + suffix);
                if (Strings.isNullOrEmpty(desc)) continue;
                ProblemCat pc = new ProblemCat();
                pc.problem = problem;
                pc.description = desc;
                w.writeRow(pc);
            }
        }
    }

    public void exportPlanData() {
        this.exportGors();
        this.exportGars();
        this.exportWorkplaceActivities();
        this.exportCrs();
        this.exportSrs();
    }

    @VisibleForTesting
    ErrorLog getErrorLog() {
        return this.errorLog;
    }

    private class GarTimes {
        final long bruttoStart;
        final long startDate;
        final long endDate;

        GarTimes(GeneralizedActionRequest gar) {
            String capReq = gar.getAction().getCapabilityReq();
            if (capReq.equals("_cooperation")) {
                if (gar.getAction().getMinTimeToPrepare() > 0L) {
                    this.startDate = this.bruttoStart = gar.getStartDate() - gar.getAction().getMinTimeToPrepare();
                    this.endDate = gar.getStartDate();
                } else {
                    this.bruttoStart = -9223372036854775708L;
                    this.startDate = -9223372036854775708L;
                    this.endDate = this.getCoopReturnDate(gar);
                }
            } else {
                this.bruttoStart = this.bruttoStart(gar);
                this.startDate = gar.getStartDate();
                this.endDate = gar.getEndDate();
            }
        }

        private long getCoopReturnDate(GeneralizedActionRequest gar) {
            List<MaterialQuantity> coopMqs = gar.getAction().getBom().ingredients().stream().filter(mq -> mq.getMaterial().getName().startsWith("_cooperation_return_")).toList();
            if (coopMqs.size() != 1) {
                return -9223372036854775708L;
            }
            Material coopMat = coopMqs.get(0).getMaterial();
            List<StoreActivity> coopMatActs = DataOutExporter.this.superplan.getPlan().getStoreSchedule(StoreType.ACTUAL_ESTIMATE_VIEW).getActivities(coopMat);
            long lastTime = Long.MAX_VALUE;
            boolean added = false;
            for (StoreActivity sa : coopMatActs) {
                if (sa.getQty() < -1.0E-7) {
                    if (lastTime < sa.getTime()) {
                        return -9223372036854775708L;
                    }
                    lastTime = sa.getTime();
                }
                if (!(sa.getQty() > 1.0E-7)) continue;
                if (added || lastTime < sa.getTime()) {
                    return -9223372036854775708L;
                }
                added = true;
            }
            if (!added) {
                return -9223372036854775708L;
            }
            return coopMatActs.get(0).getTime();
        }

        private long bruttoStart(GeneralizedActionRequest gar) {
            long rebStart = gar.getStartDate();
            if (!gar.getActivities().isEmpty()) {
                WorkplaceSchedule wps = gar.getSuperplan().getPlan().getWorkplaceSchedule(gar.getActivities().get(0).getWorkplace());
                Iterator<WorkplaceActivity> iter = wps.backwardIteratorWithBubbles(gar.getStartDate(), false);
                while (iter.hasNext()) {
                    WorkplaceActivity a = iter.next();
                    if (a instanceof RebuildActivity) {
                        rebStart = a.getStart();
                        continue;
                    }
                    if (a instanceof OfflineActivity) continue;
                    break;
                }
            }
            return rebStart;
        }
    }

    private class WaRowWriterVisitor
    implements WorkplaceActivityVisitor {
        private static final long MAX_WPA_DURATION = 157680000000L;
        private final PropertyDefinition garMidPd;
        private final TabularWriter.RowsWriter<WorkplaceActivities> rowsWriter;
        private final CapabilityIsland island;
        private final Workplace wp;
        private RebuildActivity rebuild = null;

        WaRowWriterVisitor(TabularWriter.RowsWriter<WorkplaceActivities> rowsWriter, CapabilityIsland island, Workplace wp, PropertyDefinition garMidPd) {
            this.rowsWriter = rowsWriter;
            this.island = island;
            this.wp = wp;
            this.garMidPd = garMidPd;
        }

        @Override
        public void visit(OfflineActivity offline) {
        }

        @Override
        public void visit(ActionActivity actionActivity) {
            GeneralizedActionRequest gar = actionActivity.getGar();
            GeneralizedOrderRequest gor = ProductionTreeAlgorithms.getNearestGor(gar);
            String mId = (String)gar.getProperty(this.garMidPd);
            if (this.rebuild != null) {
                this.writeRecord(this.rebuild, "setup", gor.getId(), gar.getAction().getName(), mId);
                this.rebuild = null;
            }
            this.writeRecord(actionActivity, "manuf", gor.getId(), gar.getAction().getName(), mId);
        }

        @Override
        public void visit(CumulativeWorkplaceActivity cumActivity) {
            for (ActionActivity aa : cumActivity.getActionActivities()) {
                this.visit(aa);
            }
        }

        @Override
        public void visit(RebuildActivity rebuildActivity) {
            if (this.rebuild != null) {
                this.writeRecord(this.rebuild, "setup", "", "", "");
            }
            this.rebuild = rebuildActivity;
        }

        @Override
        public void visit(Bubble bubble) {
        }

        private void writeRecord(WorkplaceActivity wa, String type, String orderName, String actionName, String mId) {
            if (wa.getDuration() > 157680000000L) {
                if (Strings.isNullOrEmpty(orderName)) {
                    DataOutExporter.this.errorLog.add(1, "data_out_export.too_long_wa", "type", type, "wp", wa.getWorkplace().getName(), "start", Instant.ofEpochMilli(wa.getStart()));
                } else {
                    DataOutExporter.this.errorLog.add(1, "data_out_export.too_long_aa", "mo", orderName, "op", actionName, "wp", wa.getWorkplace().getName(), "start", Instant.ofEpochMilli(wa.getStart()));
                }
                return;
            }
            for (TimeSpan span : CalendarHelper.splitAtMidnight(wa.getStart(), wa.getEnd())) {
                WorkplaceActivities act = new WorkplaceActivities();
                act.workcenterName = this.island.getName();
                act.workplaceName = this.wp.getName();
                act.start = span.getStart();
                act.end = span.getEnd();
                act.type = type;
                act.orderName = orderName;
                act.actionName = actionName;
                act.mId = mId;
                this.rowsWriter.writeRow(act);
            }
        }
    }
}

